/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: lldp_error.h 48772 2014-10-22 08:57:35Z Benjamin $:

Description:
 LLDP
 Includes LLDP task error codes
**************************************************************************************/
#ifndef __LLDP_ERROR_H
#define __LLDP_ERROR_H


/////////////////////////////////////////////////////////////////////////////////////
// LLDp Protocol
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_LLDP_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command.
//
#define TLR_E_LLDP_COMMAND_INVALID       ((TLR_RESULT)0xC03E0001L)

//
// MessageId: TLR_I_LLDP_UNKNOWN_TLV
//
// MessageText:
//
//  Unknwon TLV found.
//
#define TLR_I_LLDP_UNKNOWN_TLV           ((TLR_RESULT)0x403E0002L)

//
// MessageId: TLR_E_LLDP_PDU_MAX_SIZE_EXCEEDED
//
// MessageText:
//
//  Maximum Ethernet frame size exceeded.
//
#define TLR_E_LLDP_PDU_MAX_SIZE_EXCEEDED ((TLR_RESULT)0xC03E0003L)

//
// MessageId: TLR_E_LLDP_TLV_DISCARDED
//
// MessageText:
//
//  Invalid TLV content.
//
#define TLR_E_LLDP_TLV_DISCARDED         ((TLR_RESULT)0xC03E0004L)

//
// MessageId: TLR_E_LLDP_FRAME_DISCARDED
//
// MessageText:
//
//  One of TLVs has a wrong size or invalid mandatory TLV sequence.
//
#define TLR_E_LLDP_FRAME_DISCARDED       ((TLR_RESULT)0xC03E0005L)

//
// MessageId: TLR_E_LLDP_WRONG_PARAMETERS
//
// MessageText:
//
//  Parameters sent to the task are wrong.
//
#define TLR_E_LLDP_WRONG_PARAMETERS      ((TLR_RESULT)0xC03E0006L)

//
// MessageId: TLR_E_NO_MIBS
//
// MessageText:
//
//  The Task was unable to recreate MIBs during a reset due to insufficient memory.
//
#define TLR_E_NO_MIBS                    ((TLR_RESULT)0xC03E0007L)

//
// MessageId: TLR_E_CONFIG_WRONG_PORT_TOO_HIGH
//
// MessageText:
//
//  Configured Port higher then configured at startup parameter.
//
#define TLR_E_CONFIG_WRONG_PORT_TOO_HIGH ((TLR_RESULT)0xC03E0008L)

//
// MessageId: TLR_E_CONFIG_WRONG_STATUS_RT_2
//
// MessageText:
//
//  Configured a to high RT2 Status
//
#define TLR_E_CONFIG_WRONG_STATUS_RT_2   ((TLR_RESULT)0xC03E0009L)

//
// MessageId: TLR_E_CONFIG_WRONG_STATUS_RT_3
//
// MessageText:
//
//  Configured a to high RT3 Status
//
#define TLR_E_CONFIG_WRONG_STATUS_RT_3   ((TLR_RESULT)0xC03E000AL)

//
// MessageId: TLR_E_CONFIG_WRONG_MODE_RT3
//
// MessageText:
//
//  Configured a to high RT3 Mode
//
#define TLR_E_CONFIG_WRONG_MODE_RT3      ((TLR_RESULT)0xC03E000BL)

//
// MessageId: TLR_E_CONFIG_SEND_ENABLE_RANGE
//
// MessageText:
//
//  Configured a wrong value for TX send enable
//
#define TLR_E_CONFIG_SEND_ENABLE_RANGE   ((TLR_RESULT)0xC03E000CL)

//
// MessageId: TLR_E_CONFIG_WRONG_ADMIN_STATUS
//
// MessageText:
//
//  Configured a wrong value for admin state
//
#define TLR_E_CONFIG_WRONG_ADMIN_STATUS  ((TLR_RESULT)0xC03E000DL)

//
// MessageId: TLR_E_CONFIG_WRONG_PARAM_NOTIFIC_ENABLE
//
// MessageText:
//
//  Configured a wrong value for notification enable
//
#define TLR_E_CONFIG_WRONG_PARAM_NOTIFIC_ENABLE ((TLR_RESULT)0xC03E000EL)

//
// MessageId: TLR_E_CONFIG_WRONG_TX_ENABLE_VALUE
//
// MessageText:
//
//  Configured a to high value for TX enable
//
#define TLR_E_CONFIG_WRONG_TX_ENABLE_VALUE ((TLR_RESULT)0xC03E000FL)

//
// MessageId: TLR_E_CONFIG_PORT_ID_SIZE_MAX_FAULT
//
// MessageText:
//
//  Configured a to long port id size
//
#define TLR_E_CONFIG_PORT_ID_SIZE_MAX_FAULT ((TLR_RESULT)0xC03E0010L)

//
// MessageId: TLR_E_CONFIG_PORT_ID_SIZE_MIN_FAULT
//
// MessageText:
//
//  Configured a to short port id size
//
#define TLR_E_CONFIG_PORT_ID_SIZE_MIN_FAULT ((TLR_RESULT)0xC03E0011L)

//
// MessageId: TLR_E_CONFIG_WRONG_PORT_ID_TYPE_MAX
//
// MessageText:
//
//  Configured a wrong to large port id type
//
#define TLR_E_CONFIG_WRONG_PORT_ID_TYPE_MAX ((TLR_RESULT)0xC03E0012L)

//
// MessageId: TLR_E_CONFIG_WRONG_PORT_ID_TYPE_MIN
//
// MessageText:
//
//  Configured a wrong to short port id type
//
#define TLR_E_CONFIG_WRONG_PORT_ID_TYPE_MIN ((TLR_RESULT)0xC03E0013L)

//
// MessageId: TLR_E_CONFIG_TO_LONG_PORT_DESCR
//
// MessageText:
//
//  Configured a to long port description
//
#define TLR_E_CONFIG_TO_LONG_PORT_DESCR  ((TLR_RESULT)0xC03E0014L)

//
// MessageId: TLR_E_CONFIG_MAX_CHASSIS_ID
//
// MessageText:
//
//  Configured a too long chassis id type
//
#define TLR_E_CONFIG_MAX_CHASSIS_ID      ((TLR_RESULT)0xC03E0015L)

//
// MessageId: TLR_E_CONFIG_MIN_CHASSIS_ID
//
// MessageText:
//
//  Configured a too short chassis id type
//
#define TLR_E_CONFIG_MIN_CHASSIS_ID      ((TLR_RESULT)0xC03E0016L)

//
// MessageId: TLR_E_CONFIG_MAX_TX_INTERVAL
//
// MessageText:
//
//  Configured a too long TX interval
//
#define TLR_E_CONFIG_MAX_TX_INTERVAL     ((TLR_RESULT)0xC03E0017L)

//
// MessageId: TLR_E_CONFIG_MIN_TX_INTERVAL
//
// MessageText:
//
//  Configured a too short TX interval
//
#define TLR_E_CONFIG_MIN_TX_INTERVAL     ((TLR_RESULT)0xC03E0018L)

//
// MessageId: TLR_E_CONFIG_MAX_PPVID
//
// MessageText:
//
//  Configured a too large PPVID
//
#define TLR_E_CONFIG_MAX_PPVID           ((TLR_RESULT)0xC03E0019L)

//
// MessageId: TLR_E_CONFIG_MIN_PPVID
//
// MessageText:
//
//  Configured a too short PPVID
//
#define TLR_E_CONFIG_MIN_PPVID           ((TLR_RESULT)0xC03E001AL)

//
// MessageId: TLR_E_CONFIG_WRONG_LLDP_SEND_STATE
//
// MessageText:
//
//  Configured wrong LLDP send state
//
#define TLR_E_CONFIG_WRONG_LLDP_SEND_STATE ((TLR_RESULT)0xC03E001BL)

//
// MessageId: TLR_E_CONFIG_TOO_LARGE_DESCRIPTION
//
// MessageText:
//
//  Configured a too large system description
//
#define TLR_E_CONFIG_TOO_LARGE_DESCRIPTION ((TLR_RESULT)0xC03E001CL)

//
// MessageId: TLR_E_CONFIG_WRONG_AUTO_NEG_STATE
//
// MessageText:
//
//  Configured a wrong Autonegation state
//
#define TLR_E_CONFIG_WRONG_AUTO_NEG_STATE ((TLR_RESULT)0xC03E001DL)

//
// MessageId: TLR_E_CONFIG_WRONG_AUTO_NEG_SUPPORTED
//
// MessageText:
//
//  Configured a wrong Autonegation supported state
//
#define TLR_E_CONFIG_WRONG_AUTO_NEG_SUPPORTED ((TLR_RESULT)0xC03E001EL)

//
// MessageId: TLR_E_CONFIG_WRONG_AUTO_NEG_ADVERTISED
//
// MessageText:
//
//  Configured a wrong Autonegation advertised state
//
#define TLR_E_CONFIG_WRONG_AUTO_NEG_ADVERTISED ((TLR_RESULT)0xC03E001FL)

//
// MessageId: TLR_E_CONFIG_MAX_MAU_TYPE
//
// MessageText:
//
//  Configured a too high MAU type
//
#define TLR_E_CONFIG_MAX_MAU_TYPE        ((TLR_RESULT)0xC03E0020L)

//
// MessageId: TLR_E_CONFIG_MIN_MAU_TYPE
//
// MessageText:
//
//  Configured a too low MAU type
//
#define TLR_E_CONFIG_MIN_MAU_TYPE        ((TLR_RESULT)0xC03E0021L)

//
// MessageId: TLR_E_CONFIG_PPVID_FAILED
//
// MessageText:
//
//  PPVID was previousley not defined
//
#define TLR_E_CONFIG_PPVID_FAILED        ((TLR_RESULT)0xC03E0022L)

//
// MessageId: TLR_E_IF_TYPE_MAX
//
// MessageText:
//
//  IF TYPE too large
//
#define TLR_E_IF_TYPE_MAX                ((TLR_RESULT)0xC03E0023L)

//
// MessageId: TLR_E_IF_TYPE_MIN
//
// MessageText:
//
//  IF TYPE too small
//
#define TLR_E_IF_TYPE_MIN                ((TLR_RESULT)0xC03E0024L)

//
// MessageId: TLR_E_OID_MAX
//
// MessageText:
//
//  OID too long
//
#define TLR_E_OID_MAX                    ((TLR_RESULT)0xC03E0025L)

//
// MessageId: TLR_E_MANAGEMENT_ADDRESS_MAX
//
// MessageText:
//
//  Mangement address size too high
//
#define TLR_E_MANAGEMENT_ADDRESS_MAX     ((TLR_RESULT)0xC03E0026L)

//
// MessageId: TLR_E_MANAGEMENT_ADDRESS_MIN
//
// MessageText:
//
//  Mangement address size too low
//
#define TLR_E_MANAGEMENT_ADDRESS_MIN     ((TLR_RESULT)0xC03E0027L)

//
// MessageId: TLR_E_MANAGEMENT_ADDRESS_ID_INVALID
//
// MessageText:
//
//  Management address id not found. Address shall not exist.
//
#define TLR_E_MANAGEMENT_ADDRESS_ID_INVALID ((TLR_RESULT)0xC03E0028L)

//
// MessageId: TLR_E_TX_HOLD_MAX
//
// MessageText:
//
//  Value for TX hold too high
//
#define TLR_E_TX_HOLD_MAX                ((TLR_RESULT)0xC03E0029L)

//
// MessageId: TLR_E_TX_HOLD_MIN
//
// MessageText:
//
//  Value for TX hold too low
//
#define TLR_E_TX_HOLD_MIN                ((TLR_RESULT)0xC03E003AL)

//
// MessageId: TLR_E_REINIT_DELAY_MAX
//
// MessageText:
//
//  Value for the reinit delay is too high
//
#define TLR_E_REINIT_DELAY_MAX           ((TLR_RESULT)0xC03E003BL)

//
// MessageId: TLR_E_REINIT_DELAY_MIN
//
// MessageText:
//
//  Value for the reinit delay is too low
//
#define TLR_E_REINIT_DELAY_MIN           ((TLR_RESULT)0xC03E003CL)

//
// MessageId: TLR_E_TX_DELAY_MAX
//
// MessageText:
//
//  Value for the tx delay is too high
//
#define TLR_E_TX_DELAY_MAX               ((TLR_RESULT)0xC03E003DL)

//
// MessageId: TLR_E_TX_DELAY_MIN
//
// MessageText:
//
//  Value for the tx delay is too low
//
#define TLR_E_TX_DELAY_MIN               ((TLR_RESULT)0xC03E003EL)

//
// MessageId: TLR_E_NOTIFICATION_INTERVALL_MAX
//
// MessageText:
//
//  Value for the notification intervall to high
//
#define TLR_E_NOTIFICATION_INTERVALL_MAX ((TLR_RESULT)0xC03E003FL)

//
// MessageId: TLR_E_NOTIFICATION_INTERVALL_MIN
//
// MessageText:
//
//  Value for the notification intervall too low
//
#define TLR_E_NOTIFICATION_INTERVALL_MIN ((TLR_RESULT)0xC03E0040L)

//
// MessageId: TLR_E_PVID_MAX
//
// MessageText:
//
//  Value for the pvid too high
//
#define TLR_E_PVID_MAX                   ((TLR_RESULT)0xC03E0041L)

//
// MessageId: TLR_E_PVID_MIN
//
// MessageText:
//
//  Value for the pvid too low
//
#define TLR_E_PVID_MIN                   ((TLR_RESULT)0xC03E0042L)

//
// MessageId: TLR_E_PPVID_MAX
//
// MessageText:
//
//  Value for the ppvid too high
//
#define TLR_E_PPVID_MAX                  ((TLR_RESULT)0xC03E0043L)

//
// MessageId: TLR_E_PPVID_ENABLED
//
// MessageText:
//
//  Value for ppvid enabled out of range
//
#define TLR_E_PPVID_ENABLED              ((TLR_RESULT)0xC03E0044L)

//
// MessageId: TLR_E_PPVID_SUPPORTED
//
// MessageText:
//
//  Value for ppvid supported out of range
//
#define TLR_E_PPVID_SUPPORTED            ((TLR_RESULT)0xC03E0045L)

//
// MessageId: TLR_E_WRONG_PARAMETER_COMBINATION
//
// MessageText:
//
//  The combination of the different configured values dosen't fit
//
#define TLR_E_WRONG_PARAMETER_COMBINATION ((TLR_RESULT)0xC03E0046L)

//
// MessageId: TLR_E_NOT_ENOUGH_STORAGE_TLV
//
// MessageText:
//
//  Not enough storage for so much of these TLV's
//
#define TLR_E_NOT_ENOUGH_STORAGE_TLV     ((TLR_RESULT)0xC03E0047L)

//
// MessageId: TLR_E_VLAN_NAME_MAX
//
// MessageText:
//
//  Vlan name length too long
//
#define TLR_E_VLAN_NAME_MAX              ((TLR_RESULT)0xC03E0048L)

//
// MessageId: TLR_E_VLAN_NAME_MIN
//
// MessageText:
//
//  Vlan name length too short
//
#define TLR_E_VLAN_NAME_MIN              ((TLR_RESULT)0xC03E0049L)

//
// MessageId: TLR_E_VLAN_ID_MAX
//
// MessageText:
//
//  Vlan id length too long
//
#define TLR_E_VLAN_ID_MAX                ((TLR_RESULT)0xC03E004AL)

//
// MessageId: TLR_E_VLAN_ID_MIN
//
// MessageText:
//
//  Vlan id length too short
//
#define TLR_E_VLAN_ID_MIN                ((TLR_RESULT)0xC03E004BL)

//
// MessageId: TLR_E_PID_MAX
//
// MessageText:
//
//  Pid length too long
//
#define TLR_E_PID_MAX                    ((TLR_RESULT)0xC03E004CL)

//
// MessageId: TLR_E_MDI_ENABLE_RANGE
//
// MessageText:
//
//  MDI Enable out of range
//
#define TLR_E_MDI_ENABLE_RANGE           ((TLR_RESULT)0xC03E004DL)

//
// MessageId: TLR_E_MDI_SUPPORTED_RANGE
//
// MessageText:
//
//  MDI Supported out of range
//
#define TLR_E_MDI_SUPPORTED_RANGE        ((TLR_RESULT)0xC03E004EL)

//
// MessageId: TLR_E_PAIR_CONTROLLABEL_RANGE
//
// MessageText:
//
//  Pair controllable out of range
//
#define TLR_E_PAIR_CONTROLLABEL_RANGE    ((TLR_RESULT)0xC03E004FL)

//
// MessageId: TLR_E_PORT_CLASS_RANGE
//
// MessageText:
//
//  Port class out of range
//
#define TLR_E_PORT_CLASS_RANGE           ((TLR_RESULT)0xC03E0050L)

//
// MessageId: TLR_E_CLASS_MAX
//
// MessageText:
//
//  Value for class too high
//
#define TLR_E_CLASS_MAX                  ((TLR_RESULT)0xC03E0051L)

//
// MessageId: TLR_E_CLASS_MIN
//
// MessageText:
//
//  Value for class too low
//
#define TLR_E_CLASS_MIN                  ((TLR_RESULT)0xC03E0052L)

//
// MessageId: TLR_E_PAIRS_MAX
//
// MessageText:
//
//  Value for pairs too high
//
#define TLR_E_PAIRS_MAX                  ((TLR_RESULT)0xC03E0053L)

//
// MessageId: TLR_E_PAIRS_MIN
//
// MessageText:
//
//  Value for pairs too low
//
#define TLR_E_PAIRS_MIN                  ((TLR_RESULT)0xC03E0054L)

//
// MessageId: TLR_E_LA_SUPPORTED_RANGE
//
// MessageText:
//
//  Value for LA Supported out of range
//
#define TLR_E_LA_SUPPORTED_RANGE         ((TLR_RESULT)0xC03E0055L)

//
// MessageId: TLR_E_LA_ENABLED_RANGE
//
// MessageText:
//
//  Value for LA Enabled out of range
//
#define TLR_E_LA_ENABLED_RANGE           ((TLR_RESULT)0xC03E0056L)

//
// MessageId: TLR_E_AGG_PORT_ID_MAX
//
// MessageText:
//
//  Value for Agg Port ID too high
//
#define TLR_E_AGG_PORT_ID_MAX            ((TLR_RESULT)0xC03E0057L)

//
// MessageId: TLR_E_MFS_MAX
//
// MessageText:
//
//  Value for Mfs too high
//
#define TLR_E_MFS_MAX                    ((TLR_RESULT)0xC03E0058L)

//
// MessageId: TLR_E_MFS_MIN
//
// MessageText:
//
//  Value for Mfs too low
//
#define TLR_E_MFS_MIN                    ((TLR_RESULT)0xC03E0059L)

//
// MessageId: TLR_E_NOS_MAX
//
// MessageText:
//
//  Name of station too long
//
#define TLR_E_NOS_MAX                    ((TLR_RESULT)0xC03E005AL)

//
// MessageId: TLR_E_MRRT_STATE_RANGE
//
// MessageText:
//
//  Value of MRRT state out of range
//
#define TLR_E_MRRT_STATE_RANGE           ((TLR_RESULT)0xC03E005BL)

//
// MessageId: TLR_E_LENGTH_PERIOD_MAX
//
// MessageText:
//
//  Value of Length of period too high
//
#define TLR_E_LENGTH_PERIOD_MAX          ((TLR_RESULT)0xC03E005CL)

//
// MessageId: TLR_E_RED_PERIOD_BEGIN_MAX
//
// MessageText:
//
//  Value of Length of red period begin is too high
//
#define TLR_E_RED_PERIOD_BEGIN_MAX       ((TLR_RESULT)0xC03E005DL)

//
// MessageId: TLR_E_ORANGE_PERIOD_BEGIN_MAX
//
// MessageText:
//
//  Value of Length of orange period begin is too high
//
#define TLR_E_ORANGE_PERIOD_BEGIN_MAX    ((TLR_RESULT)0xC03E005EL)

//
// MessageId: TLR_E_GREEN_PERIOD_BEGIN_MAX
//
// MessageText:
//
//  Value of Length of green period begin is too high
//
#define TLR_E_GREEN_PERIOD_BEGIN_MAX     ((TLR_RESULT)0xC03E005FL)

//
// MessageId: TLR_E_LENGTH_PERIOD_MIN
//
// MessageText:
//
//  Value of length of period is too low
//
#define TLR_E_LENGTH_PERIOD_MIN          ((TLR_RESULT)0xC03E0060L)




#endif  //__LLDP_ERROR_H

